// Generated by delombok at Thu Dec 04 18:36:34 UTC 2025
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

@Schema(description = "The ESRD claim data to process for pricing.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BUNDLED-BILL-PORTION", value = "<structure>")})})
public class EsrdClaimData extends ClaimData {
  @Valid
  private ComorbidityData comorbidities;
  @ArraySchema(arraySchema = @Schema(description = "The condition codes related to the claim.", example = "[\"84\" + \"73\" + \"n\"]"), uniqueItems = true)
  @Size(max = 2, min = 1)
  private List<@Pattern(regexp = "\\d{2}", message = "must be two digits") String> conditionCodes;
  @ArraySchema(arraySchema = @Schema(description = "The demo codes related to the claim.", example = "[\"83\"]"), uniqueItems = true, extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-DATA-CODE", value = "PIC X(02)")})})
  @Size(max = 4, min = 1)
  private List<@Pattern(regexp = "\\d{2}", message = "must be two digits") String> demoCodes;
  @Max(99)
  @Min(0)
  @NotNull
  @Schema(description = "The number of dialysis sessions reported.", example = "23", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-CLAIM-NUM-DIALYSIS-SESSIONS", value = "PIC 9(02)")})})
  private Integer dialysisSessionCount;
  @Schema(example = "2020-05-13", format = "yyyy-MM-dd", description = "The date dialysis was started.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-DIALYSIS-START-DATE", value = """
    B-DIALYSIS-START-DT-CCYY        PIC 9(04)\"
    + \"B-DIALYSIS-START-DT-MM          PIC 9(02)\"
    + \"B-DIALYSIS-START-DT-DD          PIC 9(02)""", parseValue = true)})})
  @StrictLocalDate
  private LocalDate dialysisStartDate;
  @NotNull
  @Schema(example = "2020-05-13", format = "yyyy-MM-dd", description = "The patient\'s date of birth.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-DOB-DATE", value = """
    B-THRU-CCYY        PIC 9(04)\"
    + \"B-THRU-MM          PIC 9(02)\"
    + \"B-THRU-DD          PIC 9(02)""", parseValue = true)})})
  @StrictLocalDate
  private LocalDate patientDateOfBirth;
  @BigDecimalScale
  @DecimalMax("9999999.99")
  @DecimalMin("0")
  @Digits(integer = 7, fraction = 2)
  @Schema(description = "The patient height in centimeters.", example = "74.23", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-PATIENT-HGT", value = "PIC 9(07)V9(02)"), @ExtensionProperty(name = "B-PATIENT-HEIGHT", value = "REDEFINES  B-PATIENT-WGT PIC 9(09)")})})
  private BigDecimal patientHeight;
  @BigDecimalScale
  @DecimalMax("9999999.99")
  @DecimalMin("0")
  @Digits(integer = 7, fraction = 2)
  @Schema(description = "The patient weight in kilograms.", example = "157.09", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-PATIENT-WGT", value = "PIC 9(07)V9(02)"), @ExtensionProperty(name = "B-PATIENT-WEIGHT", value = "REDEFINES  B-PATIENT-WGT: PIC 9(09)")})})
  private BigDecimal patientWeight;
  @DecimalMax("1.0800")
  @DecimalMin("0.0000")
  @Digits(integer = 1, fraction = 4)
  @Schema(example = "1.0700", description = "The Performance Payment Adjustment (PPA) percent applied to the " + "ESRD Treatment Choice (ETC) calculation.")
  private BigDecimal ppaAdjustmentPercent;
  @NotNull
  @Pattern(regexp = "\\d{4}", message = "must be four digits")
  @Schema(description = "The associated revenue code.", example = "0841", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-REV-CODE", value = "B-REV-CODE3 PIC X(03)\nFILLER PIC X(01)")})})
  private String revenueCode;
  @NotNull
  @Schema(example = "2020-05-13", format = "yyyy-MM-dd", description = "The date of service for the claim line item.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-LINE-ITEM-DATE-SERVICE", value = """
    B-LINE-ITEM-DATE-SERVICE        PIC 9(04)\"
    + \"B-LINE-ITEM-DT-SVC-MM          PIC 9(02)\"
    + \"B-LINE-ITEM-DT-SVC-DD          PIC 9(02)""", parseValue = true)})})
  @StrictLocalDate
  private LocalDate serviceDate;
  @NotNull
  @Schema(example = "2020-05-13", format = "yyyy-MM-dd", description = "The end date of service.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-THRU-DATE", value = """
    B-THRU-CCYY        PIC 9(04)\"
    + \"B-THRU-MM          PIC 9(02)\"
    + \"B-THRU-DD          PIC 9(02)""", parseValue = true)})})
  @StrictLocalDate
  private LocalDate serviceThroughDate;
  @BigDecimalScale
  @DecimalMax("999999999.99")
  @DecimalMin("0")
  @Digits(integer = 9, fraction = 2)
  @Schema(description = "The total price separately-billable outlier.", example = "2354.98", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-TOT-PRICE-SB-OUTLIER", value = "PIC 9(07)V9(02)")})})
  private BigDecimal totalPriceSeparatelyBillableOutlier;
  @BigDecimalScale(scale = 4)
  @DecimalMax("9999999.9999")
  @DecimalMin("0")
  @Digits(integer = 7, fraction = 4)
  @Schema(description = "The total Transitional Drug Add-on Payment Adjustment (TDAPA) amount; corresponds to " + "payer-only value code \'Q8\'.", example = "2354.9812", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-PAYER-ONLY-VC-Q8", value = "PIC 9(07)V9(04)")})})
  private BigDecimal totalTdapaAmountQ8;
  @BigDecimalScale(scale = 4)
  @DecimalMax("9999999.9999")
  @DecimalMin("0")
  @Digits(integer = 7, fraction = 4)
  @Schema(description = "The total Transitional Add-on Payment Adjustment for New and Innovative Equipment and " + "Supplies (TPNIES) amount; corresponds to payer-only value code \'QG’.", example = "4853.3195", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-PAYER-ONLY-VC-QG-AMT", value = "PIC 9(07)V9(04)")})})
  private BigDecimal totalTpniesAmountQg;
  @BigDecimalScale(scale = 4)
  @DecimalMax("9999999.9999")
  @DecimalMin("0")
  @Digits(integer = 7, fraction = 4)
  @Schema(description = "The total Transitional Add-on Payment Adjustment for New and Innovative Equipment and " + "Supplies (TPNIES) amount for capital-related assets (CRA); corresponds to " + "payer-only value code \'QH’.", example = "2354.9812", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-PAYER-ONLY-VC-QH-AMT", value = "PIC 9(07)V9(04)")})})
  private BigDecimal totalTpniesCraAmountQh;
  @Pattern(regexp = "^[HPB\\s]$", message = "must be one of \'H\', \'P\', \'B\', or \' \'")
  @Schema(example = "H", description = "Flag that indicates the ESRD Treatment Choice (ETC) that applies.")
  private String treatmentChoicesIndicator;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ComorbidityData getComorbidities() {
    return this.comorbidities;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Pattern(regexp = "\\d{2}", message = "must be two digits") String> getConditionCodes() {
    return this.conditionCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Pattern(regexp = "\\d{2}", message = "must be two digits") String> getDemoCodes() {
    return this.demoCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getDialysisSessionCount() {
    return this.dialysisSessionCount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getDialysisStartDate() {
    return this.dialysisStartDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getPatientDateOfBirth() {
    return this.patientDateOfBirth;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPatientHeight() {
    return this.patientHeight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPatientWeight() {
    return this.patientWeight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPpaAdjustmentPercent() {
    return this.ppaAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRevenueCode() {
    return this.revenueCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getServiceDate() {
    return this.serviceDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getServiceThroughDate() {
    return this.serviceThroughDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalPriceSeparatelyBillableOutlier() {
    return this.totalPriceSeparatelyBillableOutlier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalTdapaAmountQ8() {
    return this.totalTdapaAmountQ8;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalTpniesAmountQg() {
    return this.totalTpniesAmountQg;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalTpniesCraAmountQh() {
    return this.totalTpniesCraAmountQh;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTreatmentChoicesIndicator() {
    return this.treatmentChoicesIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setComorbidities(final ComorbidityData comorbidities) {
    this.comorbidities = comorbidities;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setConditionCodes(final List<@Pattern(regexp = "\\d{2}", message = "must be two digits") String> conditionCodes) {
    this.conditionCodes = conditionCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDemoCodes(final List<@Pattern(regexp = "\\d{2}", message = "must be two digits") String> demoCodes) {
    this.demoCodes = demoCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDialysisSessionCount(final Integer dialysisSessionCount) {
    this.dialysisSessionCount = dialysisSessionCount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDialysisStartDate(final LocalDate dialysisStartDate) {
    this.dialysisStartDate = dialysisStartDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPatientDateOfBirth(final LocalDate patientDateOfBirth) {
    this.patientDateOfBirth = patientDateOfBirth;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPatientHeight(final BigDecimal patientHeight) {
    this.patientHeight = patientHeight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPatientWeight(final BigDecimal patientWeight) {
    this.patientWeight = patientWeight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPpaAdjustmentPercent(final BigDecimal ppaAdjustmentPercent) {
    this.ppaAdjustmentPercent = ppaAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRevenueCode(final String revenueCode) {
    this.revenueCode = revenueCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setServiceDate(final LocalDate serviceDate) {
    this.serviceDate = serviceDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setServiceThroughDate(final LocalDate serviceThroughDate) {
    this.serviceThroughDate = serviceThroughDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalPriceSeparatelyBillableOutlier(final BigDecimal totalPriceSeparatelyBillableOutlier) {
    this.totalPriceSeparatelyBillableOutlier = totalPriceSeparatelyBillableOutlier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalTdapaAmountQ8(final BigDecimal totalTdapaAmountQ8) {
    this.totalTdapaAmountQ8 = totalTdapaAmountQ8;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalTpniesAmountQg(final BigDecimal totalTpniesAmountQg) {
    this.totalTpniesAmountQg = totalTpniesAmountQg;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalTpniesCraAmountQh(final BigDecimal totalTpniesCraAmountQh) {
    this.totalTpniesCraAmountQh = totalTpniesCraAmountQh;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTreatmentChoicesIndicator(final String treatmentChoicesIndicator) {
    this.treatmentChoicesIndicator = treatmentChoicesIndicator;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof EsrdClaimData)) return false;
    final EsrdClaimData other = (EsrdClaimData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    final java.lang.Object this$dialysisSessionCount = this.getDialysisSessionCount();
    final java.lang.Object other$dialysisSessionCount = other.getDialysisSessionCount();
    if (this$dialysisSessionCount == null ? other$dialysisSessionCount != null : !this$dialysisSessionCount.equals(other$dialysisSessionCount)) return false;
    final java.lang.Object this$comorbidities = this.getComorbidities();
    final java.lang.Object other$comorbidities = other.getComorbidities();
    if (this$comorbidities == null ? other$comorbidities != null : !this$comorbidities.equals(other$comorbidities)) return false;
    final java.lang.Object this$conditionCodes = this.getConditionCodes();
    final java.lang.Object other$conditionCodes = other.getConditionCodes();
    if (this$conditionCodes == null ? other$conditionCodes != null : !this$conditionCodes.equals(other$conditionCodes)) return false;
    final java.lang.Object this$demoCodes = this.getDemoCodes();
    final java.lang.Object other$demoCodes = other.getDemoCodes();
    if (this$demoCodes == null ? other$demoCodes != null : !this$demoCodes.equals(other$demoCodes)) return false;
    final java.lang.Object this$dialysisStartDate = this.getDialysisStartDate();
    final java.lang.Object other$dialysisStartDate = other.getDialysisStartDate();
    if (this$dialysisStartDate == null ? other$dialysisStartDate != null : !this$dialysisStartDate.equals(other$dialysisStartDate)) return false;
    final java.lang.Object this$patientDateOfBirth = this.getPatientDateOfBirth();
    final java.lang.Object other$patientDateOfBirth = other.getPatientDateOfBirth();
    if (this$patientDateOfBirth == null ? other$patientDateOfBirth != null : !this$patientDateOfBirth.equals(other$patientDateOfBirth)) return false;
    final java.lang.Object this$patientHeight = this.getPatientHeight();
    final java.lang.Object other$patientHeight = other.getPatientHeight();
    if (this$patientHeight == null ? other$patientHeight != null : !this$patientHeight.equals(other$patientHeight)) return false;
    final java.lang.Object this$patientWeight = this.getPatientWeight();
    final java.lang.Object other$patientWeight = other.getPatientWeight();
    if (this$patientWeight == null ? other$patientWeight != null : !this$patientWeight.equals(other$patientWeight)) return false;
    final java.lang.Object this$ppaAdjustmentPercent = this.getPpaAdjustmentPercent();
    final java.lang.Object other$ppaAdjustmentPercent = other.getPpaAdjustmentPercent();
    if (this$ppaAdjustmentPercent == null ? other$ppaAdjustmentPercent != null : !this$ppaAdjustmentPercent.equals(other$ppaAdjustmentPercent)) return false;
    final java.lang.Object this$revenueCode = this.getRevenueCode();
    final java.lang.Object other$revenueCode = other.getRevenueCode();
    if (this$revenueCode == null ? other$revenueCode != null : !this$revenueCode.equals(other$revenueCode)) return false;
    final java.lang.Object this$serviceDate = this.getServiceDate();
    final java.lang.Object other$serviceDate = other.getServiceDate();
    if (this$serviceDate == null ? other$serviceDate != null : !this$serviceDate.equals(other$serviceDate)) return false;
    final java.lang.Object this$serviceThroughDate = this.getServiceThroughDate();
    final java.lang.Object other$serviceThroughDate = other.getServiceThroughDate();
    if (this$serviceThroughDate == null ? other$serviceThroughDate != null : !this$serviceThroughDate.equals(other$serviceThroughDate)) return false;
    final java.lang.Object this$totalPriceSeparatelyBillableOutlier = this.getTotalPriceSeparatelyBillableOutlier();
    final java.lang.Object other$totalPriceSeparatelyBillableOutlier = other.getTotalPriceSeparatelyBillableOutlier();
    if (this$totalPriceSeparatelyBillableOutlier == null ? other$totalPriceSeparatelyBillableOutlier != null : !this$totalPriceSeparatelyBillableOutlier.equals(other$totalPriceSeparatelyBillableOutlier)) return false;
    final java.lang.Object this$totalTdapaAmountQ8 = this.getTotalTdapaAmountQ8();
    final java.lang.Object other$totalTdapaAmountQ8 = other.getTotalTdapaAmountQ8();
    if (this$totalTdapaAmountQ8 == null ? other$totalTdapaAmountQ8 != null : !this$totalTdapaAmountQ8.equals(other$totalTdapaAmountQ8)) return false;
    final java.lang.Object this$totalTpniesAmountQg = this.getTotalTpniesAmountQg();
    final java.lang.Object other$totalTpniesAmountQg = other.getTotalTpniesAmountQg();
    if (this$totalTpniesAmountQg == null ? other$totalTpniesAmountQg != null : !this$totalTpniesAmountQg.equals(other$totalTpniesAmountQg)) return false;
    final java.lang.Object this$totalTpniesCraAmountQh = this.getTotalTpniesCraAmountQh();
    final java.lang.Object other$totalTpniesCraAmountQh = other.getTotalTpniesCraAmountQh();
    if (this$totalTpniesCraAmountQh == null ? other$totalTpniesCraAmountQh != null : !this$totalTpniesCraAmountQh.equals(other$totalTpniesCraAmountQh)) return false;
    final java.lang.Object this$treatmentChoicesIndicator = this.getTreatmentChoicesIndicator();
    final java.lang.Object other$treatmentChoicesIndicator = other.getTreatmentChoicesIndicator();
    if (this$treatmentChoicesIndicator == null ? other$treatmentChoicesIndicator != null : !this$treatmentChoicesIndicator.equals(other$treatmentChoicesIndicator)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof EsrdClaimData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    final java.lang.Object $dialysisSessionCount = this.getDialysisSessionCount();
    result = result * PRIME + ($dialysisSessionCount == null ? 43 : $dialysisSessionCount.hashCode());
    final java.lang.Object $comorbidities = this.getComorbidities();
    result = result * PRIME + ($comorbidities == null ? 43 : $comorbidities.hashCode());
    final java.lang.Object $conditionCodes = this.getConditionCodes();
    result = result * PRIME + ($conditionCodes == null ? 43 : $conditionCodes.hashCode());
    final java.lang.Object $demoCodes = this.getDemoCodes();
    result = result * PRIME + ($demoCodes == null ? 43 : $demoCodes.hashCode());
    final java.lang.Object $dialysisStartDate = this.getDialysisStartDate();
    result = result * PRIME + ($dialysisStartDate == null ? 43 : $dialysisStartDate.hashCode());
    final java.lang.Object $patientDateOfBirth = this.getPatientDateOfBirth();
    result = result * PRIME + ($patientDateOfBirth == null ? 43 : $patientDateOfBirth.hashCode());
    final java.lang.Object $patientHeight = this.getPatientHeight();
    result = result * PRIME + ($patientHeight == null ? 43 : $patientHeight.hashCode());
    final java.lang.Object $patientWeight = this.getPatientWeight();
    result = result * PRIME + ($patientWeight == null ? 43 : $patientWeight.hashCode());
    final java.lang.Object $ppaAdjustmentPercent = this.getPpaAdjustmentPercent();
    result = result * PRIME + ($ppaAdjustmentPercent == null ? 43 : $ppaAdjustmentPercent.hashCode());
    final java.lang.Object $revenueCode = this.getRevenueCode();
    result = result * PRIME + ($revenueCode == null ? 43 : $revenueCode.hashCode());
    final java.lang.Object $serviceDate = this.getServiceDate();
    result = result * PRIME + ($serviceDate == null ? 43 : $serviceDate.hashCode());
    final java.lang.Object $serviceThroughDate = this.getServiceThroughDate();
    result = result * PRIME + ($serviceThroughDate == null ? 43 : $serviceThroughDate.hashCode());
    final java.lang.Object $totalPriceSeparatelyBillableOutlier = this.getTotalPriceSeparatelyBillableOutlier();
    result = result * PRIME + ($totalPriceSeparatelyBillableOutlier == null ? 43 : $totalPriceSeparatelyBillableOutlier.hashCode());
    final java.lang.Object $totalTdapaAmountQ8 = this.getTotalTdapaAmountQ8();
    result = result * PRIME + ($totalTdapaAmountQ8 == null ? 43 : $totalTdapaAmountQ8.hashCode());
    final java.lang.Object $totalTpniesAmountQg = this.getTotalTpniesAmountQg();
    result = result * PRIME + ($totalTpniesAmountQg == null ? 43 : $totalTpniesAmountQg.hashCode());
    final java.lang.Object $totalTpniesCraAmountQh = this.getTotalTpniesCraAmountQh();
    result = result * PRIME + ($totalTpniesCraAmountQh == null ? 43 : $totalTpniesCraAmountQh.hashCode());
    final java.lang.Object $treatmentChoicesIndicator = this.getTreatmentChoicesIndicator();
    result = result * PRIME + ($treatmentChoicesIndicator == null ? 43 : $treatmentChoicesIndicator.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "EsrdClaimData(comorbidities=" + this.getComorbidities() + ", conditionCodes=" + this.getConditionCodes() + ", demoCodes=" + this.getDemoCodes() + ", dialysisSessionCount=" + this.getDialysisSessionCount() + ", dialysisStartDate=" + this.getDialysisStartDate() + ", patientDateOfBirth=" + this.getPatientDateOfBirth() + ", patientHeight=" + this.getPatientHeight() + ", patientWeight=" + this.getPatientWeight() + ", ppaAdjustmentPercent=" + this.getPpaAdjustmentPercent() + ", revenueCode=" + this.getRevenueCode() + ", serviceDate=" + this.getServiceDate() + ", serviceThroughDate=" + this.getServiceThroughDate() + ", totalPriceSeparatelyBillableOutlier=" + this.getTotalPriceSeparatelyBillableOutlier() + ", totalTdapaAmountQ8=" + this.getTotalTdapaAmountQ8() + ", totalTpniesAmountQg=" + this.getTotalTpniesAmountQg() + ", totalTpniesCraAmountQh=" + this.getTotalTpniesCraAmountQh() + ", treatmentChoicesIndicator=" + this.getTreatmentChoicesIndicator() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public EsrdClaimData() {
  }
}
