// Generated by delombok at Thu Dec 04 18:36:34 UTC 2025
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import java.math.BigDecimal;

@Schema(description = "The outlier billing information for display; separate from the claim pricing result.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-DATA-TEST", value = "<structure>")})})
public class OutlierBillingData {
  @BigDecimalScale(scale = 3)
  @DecimalMin("0")
  @DecimalMax("9.999")
  @Digits(integer = 1, fraction = 3)
  @Schema(example = "1.017", description = "The outlier age factor.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-AGE-FACTOR", value = "PIC 9(01)V9(03)")})})
  @FixedValue
  private BigDecimal outlierAgeAdjustmentFactor;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("999.99")
  @Digits(integer = 3, fraction = 2)
  @Schema(example = "233.45", description = "The outlier adjusted average Medicare-allowable payment (MAP) amount.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-ADJ-AVG-MAP-AMT", value = "PIC 9(03)V9(02)")})})
  @FixedValue
  private BigDecimal outlierAverageAdjustedMapAmount;
  @BigDecimalScale(scale = 4)
  @Schema(example = "13.4534", description = "The outlier body-mass index (BMI).", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-BMI", value = "PIC 9(03)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal outlierBodyMassIndex;
  @BigDecimalScale(scale = 4)
  @DecimalMin("0")
  @DecimalMax("9.9999")
  @Digits(integer = 1, fraction = 4)
  @Schema(example = "1.0683", description = "The outlier body mass index (BMI) adjustment factor used.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-BMI-FACTOR", value = "PIC 9(01)V9(04)")})})
  @FixedValue
  private BigDecimal outlierBodyMassIndexFactor;
  @BigDecimalScale(scale = 4)
  @Schema(example = "13.4534", description = "The outlier body surface area (BSA).", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-BSA", value = "PIC 9(03)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal outlierBodySurfaceArea;
  @BigDecimalScale(scale = 4)
  @Schema(example = "1.0683", description = "The body surface area (BSA) adjustment factor used.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-BSA-FACTOR", value = "PIC 9(01)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal outlierBodySurfaceAreaFactor;
  @BigDecimalScale(scale = 3)
  @DecimalMin("0")
  @DecimalMax("9.999")
  @Digits(integer = 1, fraction = 3)
  @Schema(example = "1.017", description = "The outlier comorbidity multiplier.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-COMORBID-MULTIPLIER", value = "PIC 9(01)V9(03)")})})
  @FixedValue
  private BigDecimal outlierComorbidityMultiplier;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9999.99")
  @Digits(integer = 4, fraction = 2)
  @Schema(example = "902.23", description = "The outlier fixed dollar loss amount.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-FIX-DOLLAR-LOSS", value = "PIC 9(04)V9(02)")})})
  @FixedValue
  private BigDecimal outlierFixedDollarLossAmount;
  @BigDecimalScale(scale = 4)
  @Schema(example = "1238.4534", description = "The outlier imputed Medicare-allowable payment (MAP) amount.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-IMPUTED-MAP", value = "PIC 9(04)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal outlierImputedMapAmount;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9.99")
  @Digits(integer = 1, fraction = 2)
  @Schema(example = "1.01", description = "The outlier loss-sharing percent.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-LOSS-SHARING-PCT", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal outlierLossSharingPercent;
  @BigDecimalScale(scale = 3)
  @DecimalMin("0")
  @DecimalMax("9.999")
  @Digits(integer = 1, fraction = 3)
  @Schema(example = "1.017", description = "The outlier low-volume multiplier.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-LOW-VOL-MULTIPLIER", value = "PIC 9(01)V9(03)")})})
  @FixedValue
  private BigDecimal outlierLowVolumeMultiplier;
  @BigDecimalScale(scale = 4)
  @DecimalMin("0")
  @DecimalMax("9.9999")
  @Digits(integer = 1, fraction = 4)
  @Schema(example = "1.0683", description = "The outlier onset factor used.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-ONSET-FACTOR", value = "PIC 9(01)V9(04)")})})
  @FixedValue
  private BigDecimal outlierOnsetFactor;
  @BigDecimalScale(scale = 4)
  @Schema(example = "29873.3465", description = "The outlier predicted Medicare-allowable payment (MAP) amount.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-PREDICTED-MAP", value = "PIC 9(07)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal outlierPredictedMapAmount;
  @BigDecimalScale(scale = 4)
  @Schema(example = "23.2684", description = "The outlier predicted Medicare-allowable payment (MAP) amount.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-PREDICTED-SERVICES-MAP", value = "PIC 9(02)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal outlierPredictedServicesMapAmount;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierAgeAdjustmentFactor() {
    return this.outlierAgeAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierAverageAdjustedMapAmount() {
    return this.outlierAverageAdjustedMapAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierBodyMassIndex() {
    return this.outlierBodyMassIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierBodyMassIndexFactor() {
    return this.outlierBodyMassIndexFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierBodySurfaceArea() {
    return this.outlierBodySurfaceArea;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierBodySurfaceAreaFactor() {
    return this.outlierBodySurfaceAreaFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierComorbidityMultiplier() {
    return this.outlierComorbidityMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierFixedDollarLossAmount() {
    return this.outlierFixedDollarLossAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierImputedMapAmount() {
    return this.outlierImputedMapAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierLossSharingPercent() {
    return this.outlierLossSharingPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierLowVolumeMultiplier() {
    return this.outlierLowVolumeMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierOnsetFactor() {
    return this.outlierOnsetFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierPredictedMapAmount() {
    return this.outlierPredictedMapAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierPredictedServicesMapAmount() {
    return this.outlierPredictedServicesMapAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierAgeAdjustmentFactor(final BigDecimal outlierAgeAdjustmentFactor) {
    this.outlierAgeAdjustmentFactor = outlierAgeAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierAverageAdjustedMapAmount(final BigDecimal outlierAverageAdjustedMapAmount) {
    this.outlierAverageAdjustedMapAmount = outlierAverageAdjustedMapAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierBodyMassIndex(final BigDecimal outlierBodyMassIndex) {
    this.outlierBodyMassIndex = outlierBodyMassIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierBodyMassIndexFactor(final BigDecimal outlierBodyMassIndexFactor) {
    this.outlierBodyMassIndexFactor = outlierBodyMassIndexFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierBodySurfaceArea(final BigDecimal outlierBodySurfaceArea) {
    this.outlierBodySurfaceArea = outlierBodySurfaceArea;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierBodySurfaceAreaFactor(final BigDecimal outlierBodySurfaceAreaFactor) {
    this.outlierBodySurfaceAreaFactor = outlierBodySurfaceAreaFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierComorbidityMultiplier(final BigDecimal outlierComorbidityMultiplier) {
    this.outlierComorbidityMultiplier = outlierComorbidityMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierFixedDollarLossAmount(final BigDecimal outlierFixedDollarLossAmount) {
    this.outlierFixedDollarLossAmount = outlierFixedDollarLossAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierImputedMapAmount(final BigDecimal outlierImputedMapAmount) {
    this.outlierImputedMapAmount = outlierImputedMapAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierLossSharingPercent(final BigDecimal outlierLossSharingPercent) {
    this.outlierLossSharingPercent = outlierLossSharingPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierLowVolumeMultiplier(final BigDecimal outlierLowVolumeMultiplier) {
    this.outlierLowVolumeMultiplier = outlierLowVolumeMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierOnsetFactor(final BigDecimal outlierOnsetFactor) {
    this.outlierOnsetFactor = outlierOnsetFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierPredictedMapAmount(final BigDecimal outlierPredictedMapAmount) {
    this.outlierPredictedMapAmount = outlierPredictedMapAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierPredictedServicesMapAmount(final BigDecimal outlierPredictedServicesMapAmount) {
    this.outlierPredictedServicesMapAmount = outlierPredictedServicesMapAmount;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof OutlierBillingData)) return false;
    final OutlierBillingData other = (OutlierBillingData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$outlierAgeAdjustmentFactor = this.getOutlierAgeAdjustmentFactor();
    final java.lang.Object other$outlierAgeAdjustmentFactor = other.getOutlierAgeAdjustmentFactor();
    if (this$outlierAgeAdjustmentFactor == null ? other$outlierAgeAdjustmentFactor != null : !this$outlierAgeAdjustmentFactor.equals(other$outlierAgeAdjustmentFactor)) return false;
    final java.lang.Object this$outlierAverageAdjustedMapAmount = this.getOutlierAverageAdjustedMapAmount();
    final java.lang.Object other$outlierAverageAdjustedMapAmount = other.getOutlierAverageAdjustedMapAmount();
    if (this$outlierAverageAdjustedMapAmount == null ? other$outlierAverageAdjustedMapAmount != null : !this$outlierAverageAdjustedMapAmount.equals(other$outlierAverageAdjustedMapAmount)) return false;
    final java.lang.Object this$outlierBodyMassIndex = this.getOutlierBodyMassIndex();
    final java.lang.Object other$outlierBodyMassIndex = other.getOutlierBodyMassIndex();
    if (this$outlierBodyMassIndex == null ? other$outlierBodyMassIndex != null : !this$outlierBodyMassIndex.equals(other$outlierBodyMassIndex)) return false;
    final java.lang.Object this$outlierBodyMassIndexFactor = this.getOutlierBodyMassIndexFactor();
    final java.lang.Object other$outlierBodyMassIndexFactor = other.getOutlierBodyMassIndexFactor();
    if (this$outlierBodyMassIndexFactor == null ? other$outlierBodyMassIndexFactor != null : !this$outlierBodyMassIndexFactor.equals(other$outlierBodyMassIndexFactor)) return false;
    final java.lang.Object this$outlierBodySurfaceArea = this.getOutlierBodySurfaceArea();
    final java.lang.Object other$outlierBodySurfaceArea = other.getOutlierBodySurfaceArea();
    if (this$outlierBodySurfaceArea == null ? other$outlierBodySurfaceArea != null : !this$outlierBodySurfaceArea.equals(other$outlierBodySurfaceArea)) return false;
    final java.lang.Object this$outlierBodySurfaceAreaFactor = this.getOutlierBodySurfaceAreaFactor();
    final java.lang.Object other$outlierBodySurfaceAreaFactor = other.getOutlierBodySurfaceAreaFactor();
    if (this$outlierBodySurfaceAreaFactor == null ? other$outlierBodySurfaceAreaFactor != null : !this$outlierBodySurfaceAreaFactor.equals(other$outlierBodySurfaceAreaFactor)) return false;
    final java.lang.Object this$outlierComorbidityMultiplier = this.getOutlierComorbidityMultiplier();
    final java.lang.Object other$outlierComorbidityMultiplier = other.getOutlierComorbidityMultiplier();
    if (this$outlierComorbidityMultiplier == null ? other$outlierComorbidityMultiplier != null : !this$outlierComorbidityMultiplier.equals(other$outlierComorbidityMultiplier)) return false;
    final java.lang.Object this$outlierFixedDollarLossAmount = this.getOutlierFixedDollarLossAmount();
    final java.lang.Object other$outlierFixedDollarLossAmount = other.getOutlierFixedDollarLossAmount();
    if (this$outlierFixedDollarLossAmount == null ? other$outlierFixedDollarLossAmount != null : !this$outlierFixedDollarLossAmount.equals(other$outlierFixedDollarLossAmount)) return false;
    final java.lang.Object this$outlierImputedMapAmount = this.getOutlierImputedMapAmount();
    final java.lang.Object other$outlierImputedMapAmount = other.getOutlierImputedMapAmount();
    if (this$outlierImputedMapAmount == null ? other$outlierImputedMapAmount != null : !this$outlierImputedMapAmount.equals(other$outlierImputedMapAmount)) return false;
    final java.lang.Object this$outlierLossSharingPercent = this.getOutlierLossSharingPercent();
    final java.lang.Object other$outlierLossSharingPercent = other.getOutlierLossSharingPercent();
    if (this$outlierLossSharingPercent == null ? other$outlierLossSharingPercent != null : !this$outlierLossSharingPercent.equals(other$outlierLossSharingPercent)) return false;
    final java.lang.Object this$outlierLowVolumeMultiplier = this.getOutlierLowVolumeMultiplier();
    final java.lang.Object other$outlierLowVolumeMultiplier = other.getOutlierLowVolumeMultiplier();
    if (this$outlierLowVolumeMultiplier == null ? other$outlierLowVolumeMultiplier != null : !this$outlierLowVolumeMultiplier.equals(other$outlierLowVolumeMultiplier)) return false;
    final java.lang.Object this$outlierOnsetFactor = this.getOutlierOnsetFactor();
    final java.lang.Object other$outlierOnsetFactor = other.getOutlierOnsetFactor();
    if (this$outlierOnsetFactor == null ? other$outlierOnsetFactor != null : !this$outlierOnsetFactor.equals(other$outlierOnsetFactor)) return false;
    final java.lang.Object this$outlierPredictedMapAmount = this.getOutlierPredictedMapAmount();
    final java.lang.Object other$outlierPredictedMapAmount = other.getOutlierPredictedMapAmount();
    if (this$outlierPredictedMapAmount == null ? other$outlierPredictedMapAmount != null : !this$outlierPredictedMapAmount.equals(other$outlierPredictedMapAmount)) return false;
    final java.lang.Object this$outlierPredictedServicesMapAmount = this.getOutlierPredictedServicesMapAmount();
    final java.lang.Object other$outlierPredictedServicesMapAmount = other.getOutlierPredictedServicesMapAmount();
    if (this$outlierPredictedServicesMapAmount == null ? other$outlierPredictedServicesMapAmount != null : !this$outlierPredictedServicesMapAmount.equals(other$outlierPredictedServicesMapAmount)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof OutlierBillingData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $outlierAgeAdjustmentFactor = this.getOutlierAgeAdjustmentFactor();
    result = result * PRIME + ($outlierAgeAdjustmentFactor == null ? 43 : $outlierAgeAdjustmentFactor.hashCode());
    final java.lang.Object $outlierAverageAdjustedMapAmount = this.getOutlierAverageAdjustedMapAmount();
    result = result * PRIME + ($outlierAverageAdjustedMapAmount == null ? 43 : $outlierAverageAdjustedMapAmount.hashCode());
    final java.lang.Object $outlierBodyMassIndex = this.getOutlierBodyMassIndex();
    result = result * PRIME + ($outlierBodyMassIndex == null ? 43 : $outlierBodyMassIndex.hashCode());
    final java.lang.Object $outlierBodyMassIndexFactor = this.getOutlierBodyMassIndexFactor();
    result = result * PRIME + ($outlierBodyMassIndexFactor == null ? 43 : $outlierBodyMassIndexFactor.hashCode());
    final java.lang.Object $outlierBodySurfaceArea = this.getOutlierBodySurfaceArea();
    result = result * PRIME + ($outlierBodySurfaceArea == null ? 43 : $outlierBodySurfaceArea.hashCode());
    final java.lang.Object $outlierBodySurfaceAreaFactor = this.getOutlierBodySurfaceAreaFactor();
    result = result * PRIME + ($outlierBodySurfaceAreaFactor == null ? 43 : $outlierBodySurfaceAreaFactor.hashCode());
    final java.lang.Object $outlierComorbidityMultiplier = this.getOutlierComorbidityMultiplier();
    result = result * PRIME + ($outlierComorbidityMultiplier == null ? 43 : $outlierComorbidityMultiplier.hashCode());
    final java.lang.Object $outlierFixedDollarLossAmount = this.getOutlierFixedDollarLossAmount();
    result = result * PRIME + ($outlierFixedDollarLossAmount == null ? 43 : $outlierFixedDollarLossAmount.hashCode());
    final java.lang.Object $outlierImputedMapAmount = this.getOutlierImputedMapAmount();
    result = result * PRIME + ($outlierImputedMapAmount == null ? 43 : $outlierImputedMapAmount.hashCode());
    final java.lang.Object $outlierLossSharingPercent = this.getOutlierLossSharingPercent();
    result = result * PRIME + ($outlierLossSharingPercent == null ? 43 : $outlierLossSharingPercent.hashCode());
    final java.lang.Object $outlierLowVolumeMultiplier = this.getOutlierLowVolumeMultiplier();
    result = result * PRIME + ($outlierLowVolumeMultiplier == null ? 43 : $outlierLowVolumeMultiplier.hashCode());
    final java.lang.Object $outlierOnsetFactor = this.getOutlierOnsetFactor();
    result = result * PRIME + ($outlierOnsetFactor == null ? 43 : $outlierOnsetFactor.hashCode());
    final java.lang.Object $outlierPredictedMapAmount = this.getOutlierPredictedMapAmount();
    result = result * PRIME + ($outlierPredictedMapAmount == null ? 43 : $outlierPredictedMapAmount.hashCode());
    final java.lang.Object $outlierPredictedServicesMapAmount = this.getOutlierPredictedServicesMapAmount();
    result = result * PRIME + ($outlierPredictedServicesMapAmount == null ? 43 : $outlierPredictedServicesMapAmount.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "OutlierBillingData(outlierAgeAdjustmentFactor=" + this.getOutlierAgeAdjustmentFactor() + ", outlierAverageAdjustedMapAmount=" + this.getOutlierAverageAdjustedMapAmount() + ", outlierBodyMassIndex=" + this.getOutlierBodyMassIndex() + ", outlierBodyMassIndexFactor=" + this.getOutlierBodyMassIndexFactor() + ", outlierBodySurfaceArea=" + this.getOutlierBodySurfaceArea() + ", outlierBodySurfaceAreaFactor=" + this.getOutlierBodySurfaceAreaFactor() + ", outlierComorbidityMultiplier=" + this.getOutlierComorbidityMultiplier() + ", outlierFixedDollarLossAmount=" + this.getOutlierFixedDollarLossAmount() + ", outlierImputedMapAmount=" + this.getOutlierImputedMapAmount() + ", outlierLossSharingPercent=" + this.getOutlierLossSharingPercent() + ", outlierLowVolumeMultiplier=" + this.getOutlierLowVolumeMultiplier() + ", outlierOnsetFactor=" + this.getOutlierOnsetFactor() + ", outlierPredictedMapAmount=" + this.getOutlierPredictedMapAmount() + ", outlierPredictedServicesMapAmount=" + this.getOutlierPredictedServicesMapAmount() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public OutlierBillingData() {
  }
}
