// Generated by delombok at Thu Dec 04 18:37:03 UTC 2025
package gov.cms.fiss.pricers.esrd.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.esrd.EsrdPricerConfiguration;
import java.time.LocalDate;
import java.util.Map;
import java.util.Map.Entry;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;

public class DataTables {
  private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<>();
  private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;

  public DataTables(Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable) {
    this.cbsaTable = cbsaTable;
  }

  public static DataTables forYear(int implementationYear) {
    return YEAR_LOOKUP.get(implementationYear);
  }

  /**
   * Loads data tables.
   *
   * @param pricerConfiguration the pricer configuration to use
   */
  public static void loadDataTables(EsrdPricerConfiguration pricerConfiguration) {
    final CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
    final CbsaWageIndexLookupGenerator cbsaLookupProvider = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration);
    // Load all the tables
    for (final int supportedYear : pricerConfiguration.getSupportedYears()) {
      YEAR_LOOKUP.put(supportedYear, new DataTables(cbsaLookupProvider.generate(supportedYear)));
    }
  }

  public CbsaWageIndexEntry getCbsaWageIndexEntry(String cbsa, LocalDate effectiveDate) {
    final NavigableMap<LocalDate, CbsaWageIndexEntry> entries = cbsaTable.get(cbsa);
    if (entries != null) {
      final Entry<LocalDate, CbsaWageIndexEntry> entry = entries.floorEntry(effectiveDate);
      return null == entry ? null : entry.getValue();
    }
    return null;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
    return this.cbsaTable;
  }
}
