// Generated by delombok at Fri Aug 15 18:10:46 UTC 2025
package gov.cms.fiss.pricers.ipf.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithThreeFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;

@Schema(description = "The IPF prospective payment data.", extensions = @Extension(name = "cobol-declaration", properties = @ExtensionProperty(name = "IPF-DATA-VARIABLES", value = "<structure>")))
public class IpfPaymentData extends PaymentData {
  @NotNull
  @Schema(description = "The IPF additional variables for the payment data.")
  @Valid
  private AdditionalVariableData additionalVariables = new AdditionalVariableData();
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9.99")
  @Digits(integer = 1, fraction = 2)
  @Schema(description = "The age adjustment percent.", example = "1.02", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-AGE-ADJ", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal ageAdjustmentPercent;
  @BigDecimalScale(scale = 5)
  @DecimalMin("0")
  @DecimalMax("9.99999")
  @Digits(integer = 1, fraction = 5)
  @Schema(description = "The comorbidity factor.", example = "1.12345", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-COMORB-FACTOR", value = "PIC 9(01)V9(05)")})})
  @FixedValue
  private BigDecimal comorbidityFactor;
  @BigDecimalScale(scale = 3)
  @DecimalMin("0")
  @DecimalMax("9.999")
  @Digits(integer = 1, fraction = 3)
  @Schema(description = "The cost-of-living adjustment percent.", example = "1.111", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-COLA", value = "PIC 9(01)V9(03)")})})
  @FixedValue
  private BigDecimal costOfLivingAdjustmentPercent;
  @BigDecimalScale(scale = 3)
  @Schema(description = "The cost-to-charge ratio.", example = "1.561", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-CSTCHG-RATIO", value = "PIC 9(01)V9(03)")})})
  @ValidDecimalOutputWithThreeFractionDigits
  private BigDecimal costToChargeRatio;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9.99")
  @Digits(integer = 1, fraction = 2)
  @Schema(description = "The diagnosis-related group (DRG) factor.", example = "2.33", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-DRG-FACTOR", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal diagnosisRelatedGroupFactor;
  @BigDecimalScale
  @DecimalMax("9.99")
  @DecimalMin("0")
  @Digits(integer = 1, fraction = 2)
  @Schema(description = "The emergency adjustment percent.", example = "6.83", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-EMERG-ADJ", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal emergencyAdjustmentPercent;
  @BigDecimalScale(scale = 5)
  @DecimalMax("1.00000")
  @DecimalMin("0")
  @Digits(integer = 1, fraction = 5)
  @Schema(description = "The national labor share percent.", example = "0.61022", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-LABOR-SHARE", value = "PIC 9(01)V9(05)")})})
  @FixedValue
  private BigDecimal nationalLaborSharePercent;
  @BigDecimalScale(scale = 5)
  @DecimalMax("1.00000")
  @DecimalMin("0")
  @Digits(integer = 1, fraction = 5)
  @Schema(description = "The national non-labor share percent.", example = "0.46205", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-NLABOR-SHARE", value = "PIC 9(01)V9(05)")})})
  @FixedValue
  private BigDecimal nationalNonLaborSharePercent;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9.99")
  @Digits(integer = 1, fraction = 2)
  @Schema(description = "The rural adjustment percent.", example = "5.48", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPC-GEO-RURAL-ADJ", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal ruralAdjustmentPercent;
  @BigDecimalScale
  @Schema(description = "The teaching adjustment percent.", example = "1.17", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-TEACH-ADJ", value = "PIC 9(01)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal teachingAdjustmentPercent;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AdditionalVariableData getAdditionalVariables() {
    return this.additionalVariables;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getAgeAdjustmentPercent() {
    return this.ageAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getComorbidityFactor() {
    return this.comorbidityFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCostOfLivingAdjustmentPercent() {
    return this.costOfLivingAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCostToChargeRatio() {
    return this.costToChargeRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDiagnosisRelatedGroupFactor() {
    return this.diagnosisRelatedGroupFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getEmergencyAdjustmentPercent() {
    return this.emergencyAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalLaborSharePercent() {
    return this.nationalLaborSharePercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalNonLaborSharePercent() {
    return this.nationalNonLaborSharePercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRuralAdjustmentPercent() {
    return this.ruralAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTeachingAdjustmentPercent() {
    return this.teachingAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAdditionalVariables(final AdditionalVariableData additionalVariables) {
    this.additionalVariables = additionalVariables;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAgeAdjustmentPercent(final BigDecimal ageAdjustmentPercent) {
    this.ageAdjustmentPercent = ageAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setComorbidityFactor(final BigDecimal comorbidityFactor) {
    this.comorbidityFactor = comorbidityFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCostOfLivingAdjustmentPercent(final BigDecimal costOfLivingAdjustmentPercent) {
    this.costOfLivingAdjustmentPercent = costOfLivingAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCostToChargeRatio(final BigDecimal costToChargeRatio) {
    this.costToChargeRatio = costToChargeRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiagnosisRelatedGroupFactor(final BigDecimal diagnosisRelatedGroupFactor) {
    this.diagnosisRelatedGroupFactor = diagnosisRelatedGroupFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEmergencyAdjustmentPercent(final BigDecimal emergencyAdjustmentPercent) {
    this.emergencyAdjustmentPercent = emergencyAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalLaborSharePercent(final BigDecimal nationalLaborSharePercent) {
    this.nationalLaborSharePercent = nationalLaborSharePercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalNonLaborSharePercent(final BigDecimal nationalNonLaborSharePercent) {
    this.nationalNonLaborSharePercent = nationalNonLaborSharePercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRuralAdjustmentPercent(final BigDecimal ruralAdjustmentPercent) {
    this.ruralAdjustmentPercent = ruralAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTeachingAdjustmentPercent(final BigDecimal teachingAdjustmentPercent) {
    this.teachingAdjustmentPercent = teachingAdjustmentPercent;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof IpfPaymentData)) return false;
    final IpfPaymentData other = (IpfPaymentData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    final java.lang.Object this$additionalVariables = this.getAdditionalVariables();
    final java.lang.Object other$additionalVariables = other.getAdditionalVariables();
    if (this$additionalVariables == null ? other$additionalVariables != null : !this$additionalVariables.equals(other$additionalVariables)) return false;
    final java.lang.Object this$ageAdjustmentPercent = this.getAgeAdjustmentPercent();
    final java.lang.Object other$ageAdjustmentPercent = other.getAgeAdjustmentPercent();
    if (this$ageAdjustmentPercent == null ? other$ageAdjustmentPercent != null : !this$ageAdjustmentPercent.equals(other$ageAdjustmentPercent)) return false;
    final java.lang.Object this$comorbidityFactor = this.getComorbidityFactor();
    final java.lang.Object other$comorbidityFactor = other.getComorbidityFactor();
    if (this$comorbidityFactor == null ? other$comorbidityFactor != null : !this$comorbidityFactor.equals(other$comorbidityFactor)) return false;
    final java.lang.Object this$costOfLivingAdjustmentPercent = this.getCostOfLivingAdjustmentPercent();
    final java.lang.Object other$costOfLivingAdjustmentPercent = other.getCostOfLivingAdjustmentPercent();
    if (this$costOfLivingAdjustmentPercent == null ? other$costOfLivingAdjustmentPercent != null : !this$costOfLivingAdjustmentPercent.equals(other$costOfLivingAdjustmentPercent)) return false;
    final java.lang.Object this$costToChargeRatio = this.getCostToChargeRatio();
    final java.lang.Object other$costToChargeRatio = other.getCostToChargeRatio();
    if (this$costToChargeRatio == null ? other$costToChargeRatio != null : !this$costToChargeRatio.equals(other$costToChargeRatio)) return false;
    final java.lang.Object this$diagnosisRelatedGroupFactor = this.getDiagnosisRelatedGroupFactor();
    final java.lang.Object other$diagnosisRelatedGroupFactor = other.getDiagnosisRelatedGroupFactor();
    if (this$diagnosisRelatedGroupFactor == null ? other$diagnosisRelatedGroupFactor != null : !this$diagnosisRelatedGroupFactor.equals(other$diagnosisRelatedGroupFactor)) return false;
    final java.lang.Object this$emergencyAdjustmentPercent = this.getEmergencyAdjustmentPercent();
    final java.lang.Object other$emergencyAdjustmentPercent = other.getEmergencyAdjustmentPercent();
    if (this$emergencyAdjustmentPercent == null ? other$emergencyAdjustmentPercent != null : !this$emergencyAdjustmentPercent.equals(other$emergencyAdjustmentPercent)) return false;
    final java.lang.Object this$nationalLaborSharePercent = this.getNationalLaborSharePercent();
    final java.lang.Object other$nationalLaborSharePercent = other.getNationalLaborSharePercent();
    if (this$nationalLaborSharePercent == null ? other$nationalLaborSharePercent != null : !this$nationalLaborSharePercent.equals(other$nationalLaborSharePercent)) return false;
    final java.lang.Object this$nationalNonLaborSharePercent = this.getNationalNonLaborSharePercent();
    final java.lang.Object other$nationalNonLaborSharePercent = other.getNationalNonLaborSharePercent();
    if (this$nationalNonLaborSharePercent == null ? other$nationalNonLaborSharePercent != null : !this$nationalNonLaborSharePercent.equals(other$nationalNonLaborSharePercent)) return false;
    final java.lang.Object this$ruralAdjustmentPercent = this.getRuralAdjustmentPercent();
    final java.lang.Object other$ruralAdjustmentPercent = other.getRuralAdjustmentPercent();
    if (this$ruralAdjustmentPercent == null ? other$ruralAdjustmentPercent != null : !this$ruralAdjustmentPercent.equals(other$ruralAdjustmentPercent)) return false;
    final java.lang.Object this$teachingAdjustmentPercent = this.getTeachingAdjustmentPercent();
    final java.lang.Object other$teachingAdjustmentPercent = other.getTeachingAdjustmentPercent();
    if (this$teachingAdjustmentPercent == null ? other$teachingAdjustmentPercent != null : !this$teachingAdjustmentPercent.equals(other$teachingAdjustmentPercent)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof IpfPaymentData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    final java.lang.Object $additionalVariables = this.getAdditionalVariables();
    result = result * PRIME + ($additionalVariables == null ? 43 : $additionalVariables.hashCode());
    final java.lang.Object $ageAdjustmentPercent = this.getAgeAdjustmentPercent();
    result = result * PRIME + ($ageAdjustmentPercent == null ? 43 : $ageAdjustmentPercent.hashCode());
    final java.lang.Object $comorbidityFactor = this.getComorbidityFactor();
    result = result * PRIME + ($comorbidityFactor == null ? 43 : $comorbidityFactor.hashCode());
    final java.lang.Object $costOfLivingAdjustmentPercent = this.getCostOfLivingAdjustmentPercent();
    result = result * PRIME + ($costOfLivingAdjustmentPercent == null ? 43 : $costOfLivingAdjustmentPercent.hashCode());
    final java.lang.Object $costToChargeRatio = this.getCostToChargeRatio();
    result = result * PRIME + ($costToChargeRatio == null ? 43 : $costToChargeRatio.hashCode());
    final java.lang.Object $diagnosisRelatedGroupFactor = this.getDiagnosisRelatedGroupFactor();
    result = result * PRIME + ($diagnosisRelatedGroupFactor == null ? 43 : $diagnosisRelatedGroupFactor.hashCode());
    final java.lang.Object $emergencyAdjustmentPercent = this.getEmergencyAdjustmentPercent();
    result = result * PRIME + ($emergencyAdjustmentPercent == null ? 43 : $emergencyAdjustmentPercent.hashCode());
    final java.lang.Object $nationalLaborSharePercent = this.getNationalLaborSharePercent();
    result = result * PRIME + ($nationalLaborSharePercent == null ? 43 : $nationalLaborSharePercent.hashCode());
    final java.lang.Object $nationalNonLaborSharePercent = this.getNationalNonLaborSharePercent();
    result = result * PRIME + ($nationalNonLaborSharePercent == null ? 43 : $nationalNonLaborSharePercent.hashCode());
    final java.lang.Object $ruralAdjustmentPercent = this.getRuralAdjustmentPercent();
    result = result * PRIME + ($ruralAdjustmentPercent == null ? 43 : $ruralAdjustmentPercent.hashCode());
    final java.lang.Object $teachingAdjustmentPercent = this.getTeachingAdjustmentPercent();
    result = result * PRIME + ($teachingAdjustmentPercent == null ? 43 : $teachingAdjustmentPercent.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "IpfPaymentData(additionalVariables=" + this.getAdditionalVariables() + ", ageAdjustmentPercent=" + this.getAgeAdjustmentPercent() + ", comorbidityFactor=" + this.getComorbidityFactor() + ", costOfLivingAdjustmentPercent=" + this.getCostOfLivingAdjustmentPercent() + ", costToChargeRatio=" + this.getCostToChargeRatio() + ", diagnosisRelatedGroupFactor=" + this.getDiagnosisRelatedGroupFactor() + ", emergencyAdjustmentPercent=" + this.getEmergencyAdjustmentPercent() + ", nationalLaborSharePercent=" + this.getNationalLaborSharePercent() + ", nationalNonLaborSharePercent=" + this.getNationalNonLaborSharePercent() + ", ruralAdjustmentPercent=" + this.getRuralAdjustmentPercent() + ", teachingAdjustmentPercent=" + this.getTeachingAdjustmentPercent() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public IpfPaymentData() {
  }
}
