// Generated by delombok at Fri Aug 15 18:11:27 UTC 2025
package gov.cms.fiss.pricers.ipf;

import gov.cms.fiss.pricers.common.application.OpenApiPricerApplication;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.common.application.resources.CbsaWageIndexResource;
import gov.cms.fiss.pricers.ipf.core.Ipf2020PricerContext;
import gov.cms.fiss.pricers.ipf.core.Ipf2021PricerContext;
import gov.cms.fiss.pricers.ipf.core.Ipf2022PricerContext;
import gov.cms.fiss.pricers.ipf.core.Ipf2023PricerContext;
import gov.cms.fiss.pricers.ipf.core.Ipf2024PricerContext;
import gov.cms.fiss.pricers.ipf.core.Ipf2025PricerContext;
import gov.cms.fiss.pricers.ipf.core.Ipf2026PricerContext;
import gov.cms.fiss.pricers.ipf.core.IpfPricerDispatch;
import gov.cms.fiss.pricers.ipf.resources.IpfClaimPricingResource;
import gov.cms.fiss.pricers.ipf.resources.IpfExtractionUtil;
import io.dropwizard.core.setup.Environment;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class IpfPricerApplication extends OpenApiPricerApplication<IpfPricerConfiguration> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger LOGGER = org.slf4j.LoggerFactory.getLogger(IpfPricerApplication.class);

  public static void main(String[] args) throws Exception {
    new IpfPricerApplication().run(args);
  }

  @Override
  protected void configureApplication(IpfPricerConfiguration configuration, Environment environment) {
    final IpfClaimPricingResource v2Resource = new IpfClaimPricingResource(new IpfPricerDispatch(configuration));
    environment.jersey().register(v2Resource);
    environment.jersey().register(new CbsaWageIndexResource(configuration, IpfExtractionUtil.CBSA_EXTRACTOR));
  }

  @Override
  protected List<OpenApiCustomizer> getContractCustomizers() {
    final List<OpenApiCustomizer> customizers = new ArrayList<>(super.getContractCustomizers());
    customizers.add((configuration, environment, oas) -> oas.info(new Info().title("IPF Pricer").version("v1")));
    return customizers;
  }

  @Override
  public String getName() {
    return "ipf-pricer";
  }

  @Override
  protected List<Package> getResourcePackages() {
    return Collections.singletonList(IpfClaimPricingResource.class.getPackage());
  }

  @Override
  protected Map<Integer, String> getCalculationVersions() {
    return Map.of(2020, Ipf2020PricerContext.CALCULATION_VERSION_2020, 2021, Ipf2021PricerContext.CALCULATION_VERSION_2021, 2022, Ipf2022PricerContext.CALCULATION_VERSION_2022, 2023, Ipf2023PricerContext.CALCULATION_VERSION_2023, 2024, Ipf2024PricerContext.CALCULATION_VERSION_2024, 2025, Ipf2025PricerContext.CALCULATION_VERSION_2025, 2026, Ipf2026PricerContext.CALCULATION_VERSION_2026);
  }
}
