package gov.cms.fiss.pricers.ipf.core.rules.assemble_pps_variables;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import java.math.BigDecimal;

/**
 * Initialize age adjustment values.
 *
 * <pre>
 * ***************************************************************
 * ***  GET THE AGE ADJUSTMENT
 * ***************************************************************
 * </pre>
 *
 * <p>Converted from {@code 2000-ASSEMBLE-PPS-VARIABLES} in the COBOL code.
 */
public class SetAgeAdjustmentInOutput
    implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {

  @Override
  public void calculate(IpfPricerContext calculationContext) {
    final int age = calculationContext.getClaimData().getPatientAge();
    final BigDecimal adjustment = calculationContext.getAgeAdjustment(age);
    calculationContext.getPaymentData().setAgeAdjustmentPercent(adjustment);
  }
}
