// Generated by delombok at Fri Aug 15 18:11:28 UTC 2025
package gov.cms.fiss.pricers.ipf.core.tables;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.ipf.core.tables.DrgTableEntry.Fields;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import javax.annotation.concurrent.Immutable;

/**
 * Model for the DRG CSV file.
 */
@Immutable
@JsonDeserialize(builder = DrgTableEntry.DrgTableEntryBuilder.class)
@JsonPropertyOrder({Fields.CODE, Fields.FACTOR})
public class DrgTableEntry {

  @JsonPOJOBuilder(withPrefix = "")
  public static class DrgTableEntryBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String code;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal factor;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    DrgTableEntryBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DrgTableEntry.DrgTableEntryBuilder code(final String code) {
      this.code = code;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DrgTableEntry.DrgTableEntryBuilder factor(final BigDecimal factor) {
      this.factor = factor;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DrgTableEntry build() {
      return new DrgTableEntry(this.code, this.factor);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "DrgTableEntry.DrgTableEntryBuilder(code=" + this.code + ", factor=" + this.factor + ")";
    }
  }

  @Pattern(regexp = "\\d{3}")
  private final String code;
  @Digits(integer = 1, fraction = 2)
  @BigDecimalScale
  @DecimalMin("0.00")
  @DecimalMax("9.99")
  private final BigDecimal factor;

  public DrgTableEntryBuilder copyBuilder() {
    return new DrgTableEntryBuilder().code(code).factor(factor);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  DrgTableEntry(final String code, final BigDecimal factor) {
    this.code = code;
    this.factor = factor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static DrgTableEntry.DrgTableEntryBuilder builder() {
    return new DrgTableEntry.DrgTableEntryBuilder();
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static final class Fields {
    public static final java.lang.String CODE = "code";
    public static final java.lang.String FACTOR = "factor";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCode() {
    return this.code;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFactor() {
    return this.factor;
  }
}
