// Generated by delombok at Thu Mar 14 02:28:18 UTC 2024
package gov.cms.fiss.pricers.snf.core;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum ReturnCode {
  /**
   * PDPM group rate returned.
   */
  PDPM_GROUP_RATE_RETURNED_0(0, "PDPM GROUP RATE RETURNED", "PDPM group rate returned"), /**
   * Invalid rate component.
   */
  INVALID_RATE_COMPONENT_20(20, "INVALID RATE COMPONENT", "Invalid rate component"), /**
   * Invalid CBSA or wage index.
   */
  INVALID_CBSA_OR_WAGE_INDEX_30(30, "INVALID CBSA OR WAGE INDEX", "Invalid CBSA or wage index"), /**
   * Invalid through date.
   */
  INVALID_THROUGH_DATE_40(40, "INVALID THROUGH DATE", "Invalid through date"), /**
   * Invalid federal blend for that year.
   */
  INVALID_FEDERAL_BLEND_AND_YEAR_50(50, "INVALID FEDERAL BLEND AND YEAR", "Invalid federal blend year"), /**
   * Invalid federal blend.
   */
  INVALID_FEDERAL_BLEND_60(60, "INVALID FEDERAL BLEND", "Invalid federal blend"), /**
   * Federal blend is zero and through date before Jan 1 2000.
   */
  FEDERAL_BLEND_IS_0_AND_THRU_DATE_BEFORE_2000_61(61, "FEDERAL BLEND IS ZERO AND THROUGH DATE BEFORE 2000", "Federal blend is zero and through date 2000 "), /**
   * VBP multiplier is zero.
   */
  VBP_MULTIPLIER_IS_ZERO_70(70, "VBP MULTIPLIER IS ZERO", "VBP multiplier is zero"), /**
   * PDPM units is zero.
   */
  PDPM_UNITS_IS_ZERO_80(80, "PDPM UNITS IS ZERO", "PDPM units is zero"), /**
   * Service units is zero.
   */
  SERVICE_UNITS_IS_ZERO_80(80, "SERVICE UNITS IS ZERO", "Service units is zero"), /**
   * Invalid HIPPS code.
   */
  INVALID_HIPPS_CODE_90(90, "INVALID HIPPS CODE", "Invalid HIPPS code");
  private final int code;
  private final String desc;
  private final String exp;

  ReturnCode(int code, String desc, String exp) {
    this.code = code;
    this.desc = desc;
    this.exp = exp;
  }

  public static ReturnCode fromCode(int code) {
    final Optional<ReturnCode> matchedCode = Arrays.stream(ReturnCode.values()).filter(rc -> rc.getCode() == code).findFirst();
    return matchedCode.orElse(null);
  }

  public ReturnCodeData toReturnCodeData() {
    final ReturnCodeData returnCodeData = new ReturnCodeData();
    final String paddedCode = StringUtils.leftPad(String.valueOf(this.code), 2, "0");
    returnCodeData.setCode(paddedCode);
    returnCodeData.setDescription(this.desc);
    returnCodeData.setExplanation(this.exp);
    return returnCodeData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getCode() {
    return this.code;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDesc() {
    return this.desc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getExp() {
    return this.exp;
  }
}
