// Generated by delombok at Thu Mar 14 02:28:18 UTC 2024
package gov.cms.fiss.pricers.snf.core;

import gov.cms.fiss.pricers.common.api.InternalPricerException;
import gov.cms.fiss.pricers.common.api.YearNotImplementedException;
import gov.cms.fiss.pricers.common.application.ClaimProcessor;
import gov.cms.fiss.pricers.common.application.PricerDispatch;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.snf.SnfPricerConfiguration;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingRequest;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingResponse;
import gov.cms.fiss.pricers.snf.core.tables.DataTables;
import java.time.LocalDate;

public class SnfPricerDispatch extends PricerDispatch<SnfClaimPricingRequest, SnfClaimPricingResponse, SnfPricerConfiguration> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger LOGGER = org.slf4j.LoggerFactory.getLogger(SnfPricerDispatch.class);

  public SnfPricerDispatch(SnfPricerConfiguration pricerConfiguration) {
    super(pricerConfiguration, o -> o.getReturnCodeData().getCode());
  }

  @Override
  protected void initializeReferences(SnfPricerConfiguration pricerConfiguration) {
    DataTables.loadDataTables(pricerConfiguration);
    for (final int supportedYear : pricerConfiguration.getSupportedYears()) {
      switch (supportedYear) {
      default: 
        yearReference.register(supportedYear, Snf2020RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Snf2021RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Snf2022RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Snf2023RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Snf2024RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        break;
      }
    }
  }

  @Override
  protected ClaimProcessor<SnfClaimPricingRequest, SnfClaimPricingResponse> getProcessor(SnfClaimPricingRequest input) throws YearNotImplementedException, InternalPricerException {
    return yearReference.fromFiscalYear(getAdjustedThroughDate(input.getClaimData().getServiceFromDate(), input.getClaimData().getServiceThroughDate()), "serviceThroughDate");
  }

  @Override
  protected boolean isErrorOutput(SnfClaimPricingResponse output) {
    return Integer.parseInt(output.getReturnCodeData().getCode()) >= 20;
  }

  /**
   * Converted from {@code 400-VALIDATE-SNF-INPUT} in the COBOL code.
   */
  private LocalDate getAdjustedThroughDate(LocalDate fromDate, LocalDate throughDate) {
    // *-------------------------------------------------------*
    // *---------->>  'FROM DATE' & 'THRU DATE'      <<--------*
    // *---------->>   CANNOT SPAN FISCAL YEARS      <<--------*
    // *---------->>  THIS EDIT WILL MAKE SURE       <<--------*
    // *--------->>     THE CLAIM DOES NOT           <<--------*
    // *--------->>     SPAN FISCAL YEARS            <<--------*
    // *-------------------------------------------------------*
    if (throughDate.isEqual(LocalDateUtils.fiscalYearStart(throughDate)) && fromDate.isBefore(throughDate)) {
      return throughDate.minusDays(1);
    }
    return throughDate;
  }
}
