// Generated by delombok at Thu Mar 14 02:28:18 UTC 2024
package gov.cms.fiss.pricers.snf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.snf.SnfPricerConfiguration;
import java.time.LocalDate;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;

public class DataTables {
  private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<>();
  private static final String REGION_RURAL = "RURAL";
  private static final String REGION_URBAN = "URBAN";
  /**
   * Corresponds to {@code CBSA-WI-TABLE} lookup table from the COBOL source.
   */
  private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;
  /**
   * Corresponds to {@code VARIABLE-PER-DIEM-ADJUSTMENT-FACTORS} lookup table from the COBOL source.
   */
  private final Map<Integer, VariablePerDiemEntry> variablePerDiemMap;
  /**
   * Corresponds to {@code PDPM-SLP-TABLE-U / PDPM-SLP-TABLE-R} lookup tables from the COBOL source.
   */
  private final Map<String, Map<String, SpeechLanguagePathologyRateEntry>> slpRateMap;
  /**
   * Corresponds to {@code PDPM-NTA-TABLE-U / PDPM-NTA-TABLE-R} lookup tables from the COBOL source.
   */
  private final Map<String, Map<String, NonTherapyAncillaryRateEntry>> ntaRateMap;
  /**
   * Corresponds to {@code PDPM-NURS-TABLE-U / PDPM-NURS-TABLE-R} lookup tables from the COBOL
   * source.
   */
  private final Map<String, Map<String, NursingRateEntry>> nursingRateMap;
  /**
   * Corresponds to {@code PDPM-PTOT-TABLE-U / PDPM-PTOT-TABLE-R} lookup tables from the COBOL
   * source.
   */
  private final Map<String, Map<String, PhysicalAndOccupationalTherapyRateEntry>> ptOtRateMap;

  public DataTables(Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable, Map<Integer, VariablePerDiemEntry> variablePerDiemMap, Map<String, Map<String, SpeechLanguagePathologyRateEntry>> slpRateMap, Map<String, Map<String, NonTherapyAncillaryRateEntry>> ntaRateMap, Map<String, Map<String, NursingRateEntry>> nursingRateMap, Map<String, Map<String, PhysicalAndOccupationalTherapyRateEntry>> ptOtRateMap) {
    this.cbsaTable = cbsaTable;
    this.variablePerDiemMap = variablePerDiemMap;
    this.slpRateMap = slpRateMap;
    this.ntaRateMap = ntaRateMap;
    this.nursingRateMap = nursingRateMap;
    this.ptOtRateMap = ptOtRateMap;
  }

  /**
   * Returns the data table associated with the given pricer year.
   *
   * @param pricerYear the pricer year for the claim
   * @return data table instance
   */
  public static DataTables forYear(int pricerYear) {
    return YEAR_LOOKUP.get(pricerYear);
  }

  /**
   * Loads data tables with the given CSV ingestion configuration.
   *
   * @param pricerConfiguration the pricer configuration to use
   */
  public static void loadDataTables(SnfPricerConfiguration pricerConfiguration) {
    final CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
    final CbsaWageIndexLookupGenerator cbsaWageIndexLookupGenerator = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration);
    final Map<Integer, VariablePerDiemEntry> variablePerDiemLookupMap = new VariablePerDiemLookupGenerator(csvIngestionConfiguration).generate();
    final SpeechLanguagePathologyRateLookupGenerator speechLanguagePathologyRateLookupGenerator = new SpeechLanguagePathologyRateLookupGenerator(csvIngestionConfiguration);
    final NonTherapyAncillaryRateLookupGenerator nonTherapyAncillaryRateLookupGenerator = new NonTherapyAncillaryRateLookupGenerator(csvIngestionConfiguration);
    final NursingRateLookupGenerator nursingRateLookupGenerator = new NursingRateLookupGenerator(csvIngestionConfiguration);
    final PhysicalAndOccupationalTherapyRateLookupGenerator physicalAndOccupationalTherapyRateLookupGenerator = new PhysicalAndOccupationalTherapyRateLookupGenerator(csvIngestionConfiguration);
    // Load all the tables
    for (final int pricerYear : pricerConfiguration.getSupportedYears()) {
      YEAR_LOOKUP.put(pricerYear, new DataTables(cbsaWageIndexLookupGenerator.generate(pricerYear), variablePerDiemLookupMap, speechLanguagePathologyRateLookupGenerator.generate(pricerYear), nonTherapyAncillaryRateLookupGenerator.generate(pricerYear), nursingRateLookupGenerator.generate(pricerYear), physicalAndOccupationalTherapyRateLookupGenerator.generate(pricerYear)));
    }
  }

  /**
   * Returns the CBSA wage index entry for the given CBSA and claim through date.
   *
   * @param cbsa the CBSA for provider
   * @param throughDate the end date of the claim period
   * @return the CBSA wage index record
   */
  public CbsaWageIndexEntry getCbsaWageIndexEntry(String cbsa, LocalDate throughDate) {
    final NavigableMap<LocalDate, CbsaWageIndexEntry> wageIndices = cbsaTable.get(cbsa);
    if (wageIndices == null) {
      return null;
    }
    final Map.Entry<LocalDate, CbsaWageIndexEntry> entry = wageIndices.floorEntry(throughDate);
    if (entry == null) {
      return null;
    }
    return entry.getValue().copyBuilder().build();
  }

  /**
   * Returns the variable per diem adjustment factors for the given day.
   *
   * @param day the day within the claim's period plus all prior days
   * @return the variable per diem record
   */
  public VariablePerDiemEntry getVariablePerDiemAdjustmentFactors(int day) {
    final VariablePerDiemEntry entry = variablePerDiemMap.get(day);
    return null == entry ? null : entry.copyBuilder().build();
  }

  /**
   * Returns the SLP rate based on region and group.
   *
   * @param isRural {@code true} if CBSA is rural {@code false} if CBSA is urban
   * @param group the HIPPS code group
   * @return the speech-language pathology rate record
   */
  public SpeechLanguagePathologyRateEntry getSpeechLanguagePathologyRate(boolean isRural, String group) {
    final SpeechLanguagePathologyRateEntry entry = slpRateMap.get(getRegionKey(isRural)).get(group);
    return null == entry ? null : entry.copyBuilder().build();
  }

  /**
   * Returns the NTA rates based on region and group.
   *
   * @param isRural {@code true} if CBSA is rural {@code false} if CBSA is urban
   * @param group the HIPPS code group
   * @return the non-therapy ancillary rate record
   */
  public NonTherapyAncillaryRateEntry getNonTherapyAncillaryRate(boolean isRural, String group) {
    final NonTherapyAncillaryRateEntry entry = ntaRateMap.get(getRegionKey(isRural)).get(group);
    return null == entry ? null : entry.copyBuilder().build();
  }

  /**
   * Returns the NURSING rates based on region and group.
   *
   * @param isRural {@code true} if CBSA is rural {@code false} if CBSA is urban
   * @param group the HIPPS code group
   * @return the nursing rate record
   */
  public NursingRateEntry getNursingRate(boolean isRural, String group) {
    final NursingRateEntry entry = nursingRateMap.get(getRegionKey(isRural)).get(group);
    return null == entry ? null : entry.copyBuilder().build();
  }

  /**
   * Returns the PT/OT rates based on region and group.
   *
   * @param isRural {@code true} if CBSA is rural {@code false} if CBSA is urban
   * @param group the HIPPS code group
   * @return the PT/OT rate record
   */
  public PhysicalAndOccupationalTherapyRateEntry getPhysicalAndOccupationalTherapyRate(boolean isRural, String group) {
    final PhysicalAndOccupationalTherapyRateEntry entry = ptOtRateMap.get(getRegionKey(isRural)).get(group);
    return null == entry ? null : entry.copyBuilder().build();
  }

  /**
   * Returns the region name/key based on the rural flag.
   *
   * @param isRural {@code true} if CBSA is rural {@code false} if CBSA is urban
   * @return {@value #REGION_RURAL} if {@code isRural} is {@code true} else {@value #REGION_URBAN}
   */
  private String getRegionKey(boolean isRural) {
    return isRural ? REGION_RURAL : REGION_URBAN;
  }

  /**
   * Corresponds to {@code CBSA-WI-TABLE} lookup table from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
    return this.cbsaTable;
  }
}
